/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.recap;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidable;
import ec.gob.sri.dimm.api.modelo.persistencia.Exportable;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.PagoLocalExterior;
import ec.gob.sri.dimm.ats.modelo.obj.compras.ComprobanteRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Consumo;
import ec.gob.sri.dimm.ats.modelo.obj.recap.DatosRecap;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Establecimiento;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.Constantes;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Recap
extends ObjetoModeloSucesorValidable<Iva>
implements InformacionEditable<Recap>,
Exportable,
Importable {
    private static final long serialVersionUID = -6313537778716383151L;
    public static final String CC_DETALLES_AIR = "detallesAir";
    private Establecimiento establecimiento = new Establecimiento("establecimientoRecap", "identificacionRecap", "5");
    private DatosRecap recap;
    private Consumo consumo;
    private PagoLocalExterior pagoLocalExterior;
    private ComprobanteRetencion comprobanteRetencion;
    private final List<DetalleAir> detallesAir;

    public Recap() {
        this.establecimiento.setPropietario((ObjetoModelo)this);
        this.recap = new DatosRecap();
        this.recap.setPropietario((ObjetoModelo)this);
        this.consumo = new Consumo();
        this.consumo.setPropietario((ObjetoModelo)this);
        this.comprobanteRetencion = new ComprobanteRetencion("establecimiento", "puntoEmision", "secuencial", "autorizacion", "fechaEmision");
        this.comprobanteRetencion.setPropietario((ObjetoModelo)this);
        this.pagoLocalExterior = new PagoLocalExterior();
        this.pagoLocalExterior.setPropietario((ObjetoModelo)this);
        this.detallesAir = new ArrayList<DetalleAir>();
    }

    public void inicializar() {
        this.recap.inicializar();
    }

    public Recap crearCopiaEdicion() {
        Recap copia = new Recap();
        copia.setPropietario((Iva)this.propietario);
        copia.setEstablecimiento(this.establecimiento.crearCopiaEdicion());
        copia.getEstablecimiento().setPropietario((ObjetoModelo)copia);
        copia.setRecap(this.recap.crearCopiaEdicion());
        copia.getRecap().setPropietario((ObjetoModelo)copia);
        copia.setConsumo(this.consumo.crearCopiaEdicion());
        copia.getConsumo().setPropietario((ObjetoModelo)copia);
        copia.setPagoLocalExterior(this.pagoLocalExterior.crearCopiaEdicion());
        copia.getPagoLocalExterior().setPropietario((ObjetoModelo)copia);
        copia.setComprobanteRetencion(this.comprobanteRetencion.crearCopiaEdicion());
        copia.getComprobanteRetencion().setPropietario((ObjetoModelo)copia);
        return copia;
    }

    public void actualizarInformacion(Recap copiaEdicion) {
    }

    public void agregarDetallesAir(DetalleAir detalleAir) {
        detalleAir.setPropietario((ObjetoModelo)this);
        this.detallesAir.add(detalleAir);
        this.firePropertyChange(CC_DETALLES_AIR, null, this.detallesAir);
    }

    public boolean eliminarDetallesAir(DetalleAir detalleAir) {
        boolean eliminado = this.detallesAir.remove((Object)detalleAir);
        if (eliminado) {
            this.firePropertyChange(CC_DETALLES_AIR, null, this.detallesAir);
        }
        return eliminado;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (InfoPantallas.RECAP_INFORMACION_ESTABLECIMIENTO.equals(this.getContextoValidacion().obtener(InfoPantallas.RECAP_INFORMACION_ESTABLECIMIENTO.toString()))) {
            resultado = this.establecimiento.validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            resultado = this.recap.validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
        }
        if (InfoPantallas.RECAP_PAGO_LOCAL.equals(this.getContextoValidacion().obtener(InfoPantallas.RECAP_PAGO_LOCAL.toString()))) {
            resultado = this.pagoLocalExterior.validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
            resultado = this.comprobanteRetencion.validar();
            if (!resultado.esEstadoExitoso()) {
                return resultado;
            }
        }
        return resultado.pasarValidacion();
    }

    public Establecimiento getEstablecimiento() {
        return this.establecimiento;
    }

    public DatosRecap getRecap() {
        return this.recap;
    }

    public Consumo getConsumo() {
        return this.consumo;
    }

    public PagoLocalExterior getPagoLocalExterior() {
        return this.pagoLocalExterior;
    }

    public ComprobanteRetencion getComprobanteRetencion() {
        return this.comprobanteRetencion;
    }

    public List<DetalleAir> getDetallesAir() {
        return this.detallesAir;
    }

    public void setEstablecimiento(Establecimiento establecimiento) {
        this.establecimiento = establecimiento;
    }

    public void setRecap(DatosRecap recap) {
        this.recap = recap;
    }

    public void setConsumo(Consumo consumo) {
        this.consumo = consumo;
    }

    public void setPagoLocalExterior(PagoLocalExterior pagoLocalExterior) {
        this.pagoLocalExterior = pagoLocalExterior;
    }

    public void setComprobanteRetencion(ComprobanteRetencion comprobanteRetencion) {
        this.comprobanteRetencion = comprobanteRetencion;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        this.getEstablecimiento().importar(elemento, null);
        this.getRecap().importar(elemento, null);
        this.getConsumo().importar(elemento, null);
        if (Util.existeElementoImportar(elemento, "pagoExterior")) {
            this.getPagoLocalExterior().importar(elemento, null);
        }
        this.getComprobanteRetencion().importar(elemento, null);
        NodeList nl = elemento.getElementsByTagName("detalleAir");
        int i = 0;
        while (i < nl.getLength()) {
            Node nodo = nl.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                DetalleAir detalleAir = new DetalleAir();
                detalleAir.setPropietario((ObjetoModelo)this);
                detalleAir.importar(elem, null);
                this.agregarDetallesAir(detalleAir);
            }
            ++i;
        }
        return this;
    }

    public Element exportar(Document documento, Element elemento) {
        Element detalleRecap = documento.createElement("detalleRecap");
        Element em = documento.createElement("establecimientoRecap");
        em.setTextContent(this.obtenerEstablecimientoRecap());
        detalleRecap.appendChild(em);
        em = documento.createElement("identificacionRecap");
        em.setTextContent(this.getEstablecimiento().getIdentificacion());
        detalleRecap.appendChild(em);
        if (((Iva)this.getPropietario()).periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            em = documento.createElement("parteRelRec");
            em.setTextContent(this.getEstablecimiento().getParteRelacionada());
            detalleRecap.appendChild(em);
        }
        if (((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            if (this.getEstablecimiento().getTipoProveedor() != null) {
                em = documento.createElement("tipoEst");
                em.setTextContent(this.getEstablecimiento().getTipoProveedor());
                detalleRecap.appendChild(em);
            }
            if (this.getEstablecimiento().getRazonSocial() != null) {
                em = documento.createElement("denoCliRecaps");
                em.setTextContent(this.getEstablecimiento().getRazonSocial());
                detalleRecap.appendChild(em);
            }
        }
        em = documento.createElement("tipoComprobante");
        em.setTextContent(this.getRecap().getTipoComprobante());
        detalleRecap.appendChild(em);
        em = documento.createElement("numeroRecap");
        em.setTextContent(this.getRecap().getNumeroRecap());
        detalleRecap.appendChild(em);
        em = documento.createElement("fechaPago");
        em.setTextContent(Util.dateToStringWithFormat(this.getRecap().getFechaPago(), Constantes.FORMATO_FECHA.toPattern()));
        detalleRecap.appendChild(em);
        em = documento.createElement("tarjetaCredito");
        em.setTextContent(this.getRecap().getTipoTarjetaCredito());
        detalleRecap.appendChild(em);
        em = documento.createElement("fechaEmisionRecap");
        em.setTextContent(Util.dateToStringWithFormat(this.getRecap().getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
        detalleRecap.appendChild(em);
        em = documento.createElement("consumoCero");
        em.setTextContent(this.getConsumo().getConsumoCero());
        detalleRecap.appendChild(em);
        em = documento.createElement("consumoGravado");
        em.setTextContent(this.getConsumo().getConsumoGravado());
        detalleRecap.appendChild(em);
        em = documento.createElement("totalConsumo");
        em.setTextContent(this.getConsumo().getTotalConsumo());
        detalleRecap.appendChild(em);
        em = documento.createElement("montoIva");
        em.setTextContent(this.getConsumo().getMontoIva());
        detalleRecap.appendChild(em);
        this.exportarCompensacionesDesdeMayo2016(documento, detalleRecap);
        em = documento.createElement("comision");
        em.setTextContent(this.getConsumo().getComision());
        detalleRecap.appendChild(em);
        em = documento.createElement("numeroVouchers");
        em.setTextContent(this.getConsumo().getNumVouchers());
        detalleRecap.appendChild(em);
        this.exportarRetenciones(documento, detalleRecap);
        if (this.getPagoLocalExterior() != null && ((Iva)this.getPropietario()).periodo.isPeriodoDesdeEnero2013()) {
            em = this.getPagoLocalExterior().exportar(documento, null);
            detalleRecap.appendChild(em);
        }
        em = this.obtenerAirXml(documento);
        detalleRecap.appendChild(em);
        em = documento.createElement("establecimiento");
        em.setTextContent(this.getComprobanteRetencion().getEstablecimiento());
        detalleRecap.appendChild(em);
        em = documento.createElement("puntoEmision");
        em.setTextContent(this.getComprobanteRetencion().getPuntoEmision());
        detalleRecap.appendChild(em);
        em = documento.createElement("secuencial");
        em.setTextContent(this.getComprobanteRetencion().getSecuencial());
        detalleRecap.appendChild(em);
        em = documento.createElement("autorizacion");
        em.setTextContent(this.getComprobanteRetencion().getNumAutorizacion());
        detalleRecap.appendChild(em);
        em = documento.createElement("fechaEmision");
        em.setTextContent(Util.dateToStringWithFormat(this.getComprobanteRetencion().getFechaEmision(), Constantes.FORMATO_FECHA.toPattern()));
        detalleRecap.appendChild(em);
        return detalleRecap;
    }

    private void exportarCompensacionesDesdeMayo2016(Document documento, Element detalleRecap) {
        if (((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            Element compensaciones = documento.createElement("compensaciones");
            for (Compensacion compensacion : this.getConsumo().getCompensaciones()) {
                compensaciones.appendChild(compensacion.exportar(documento, null));
            }
            detalleRecap.appendChild(compensaciones);
        }
    }

    private void exportarRetenciones(Document documento, Element detalleRecap) {
        Element em = documento.createElement("valRetBien10");
        em.setTextContent(this.getConsumo().getRetencionIvaDiez());
        detalleRecap.appendChild(em);
        em = documento.createElement("valRetServ20");
        em.setTextContent(this.getConsumo().getRetencionIvaVeinte());
        detalleRecap.appendChild(em);
        em = documento.createElement("valorRetBienes");
        em.setTextContent(this.getConsumo().getRetencionIvaBienes());
        detalleRecap.appendChild(em);
        if (((Iva)this.getPropietario()).periodo.isAnexoEnPeriodoDesdeEnero2016()) {
            em = documento.createElement("valRetServ50");
            em.setTextContent(this.getConsumo().getRetencionIvaServicios50());
            detalleRecap.appendChild(em);
        }
        em = documento.createElement("valorRetServicios");
        em.setTextContent(this.getConsumo().getRetencionIvaServicios());
        detalleRecap.appendChild(em);
        em = documento.createElement("valRetServ100");
        em.setTextContent(this.getConsumo().getRetencionIvaCien());
        detalleRecap.appendChild(em);
    }

    private String obtenerEstablecimientoRecap() {
        String establecimientoRecap = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacion("5", this.getEstablecimiento().getTipoIdentificacion());
        return establecimientoRecap;
    }

    private Element obtenerAirXml(Document documento) {
        Element air = documento.createElement("air");
        for (DetalleAir dta : this.getDetallesAir()) {
            Element em = dta.exportar(documento, null);
            air.appendChild(em);
        }
        return air;
    }
}

